package com.utimaco;

/* Copyright (c) 2020-2025 Utimaco Inc
 * License: Utimaco Demo License v1.0
 *  
 */

/* modification history **
 * ==================== **
01h,2023-06-22,riw support for ask
01g,2023-04-18,riw replaced logonpass/sign with simple login
01d-f,2023-04-18,riw presentation layer changes
01c,2023-01-03,riw remapping of keyfile/password fields
01b,2021-02-02,riw support for keyfiles
01a,2020-12-10,riw fwv
 * ==================== **
 **/

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;

public class Login {
	String user = null;
	String spec = null;
	String pin = null;
	byte [] pinbytes = null;

	File file = null;
	public boolean valid = false;

	/*
    user        Name of the user who wants to authenticate to the CryptoServer.
    keyFile        <-- mapped from -s or if mistakenly -p with 3 parameters
        Key file user: Path to key file containing user's private key.
        Password user: null.
    password    <-- mapped from -p
        Key file user: Password of the key file if using an encrypted file, null otherwise.
        Password user: Password of the user.
	 */

	public Login (String [] args, int i) {
		int c = 0;
		boolean getNext = false;
		boolean hmac = false;
		for (String a : args) {
			if (getNext) {
				getNext = false;
				String[] nkp = a.split(",");
				if (nkp.length == 2) {
					/* either
					 * -s name,key (unencrypted)
					 * -s name,:cs2...
					 * -p name,pass
					 */
					user = nkp[0];
					if (hmac) {
						pin = nkp[1];
					} else {
						spec = nkp[1];
					}
				} else if (nkp.length == 3) {
					/* like -s name,key (encrypted),passphrase */
					user = nkp[0];
					spec = nkp[1];
					pin = nkp[2];
				}
				if (!hmac) {
					file = new File(spec);
					valid = (spec.matches("^:cs2:...:.*$")) || file.exists();
				} else {
					valid = true;
				}
				if (!valid) { System.out.println("Auth param format invalid for " + a); }
				else {
					if (pin.compareToIgnoreCase("ask") == 0) {
						try {
							pinbytes = new String(readPassword("Enter password: ")).getBytes();
							// encrypt pinbytes
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else {
						pinbytes = pin.getBytes();
					}
				}
				c++;
			}

			if (a.compareTo("-s") == 0) {
				if (c != i) { c++; continue; }
				getNext = true;
				hmac = false;
			}
			if (a.compareTo("-p") == 0) {
				if (c != i) { c++; continue; }
				getNext = true;
				hmac = true;
			}
		}
	}

	boolean login (CryptoServerCXI cxi) {
		boolean ret = false;

		try {
			/* change 01g replaced logonpass/logonsign with the simple logon */
			// decrypt pinbytes into eph array
			cxi.logon(user, spec, /* eph array */pinbytes);
			// zeroize eph array
			return true;
		} catch (IOException e) {
			System.out.println(user + " login failed:  " + e.getMessage());
		} catch (CryptoServerException e) {
			System.out.println(user + " login failed:  0x" + Integer.toHexString(e.ErrorCode));
		}
		return ret;
	}

	private static String readLine(String from, Object...args) throws IOException {
		return readLine(false, from, args);
	}
	private static String readLine(boolean priv, String format, Object... args) throws IOException {
		if (priv) { return new String(readPassword(format, args)); }
		if (System.console() != null) {
			return System.console().readLine(format, args);
		}
		System.out.print(String.format(format, args));
		BufferedReader reader = new BufferedReader(new InputStreamReader(
				System.in));
		return reader.readLine();
	}

	private static char[] readPassword(String format, Object... args)
			throws IOException {
		if (System.console() != null)
			return System.console().readPassword(format, args);
		return readLine(format, args).toCharArray();
	}
	public static byte[] ReadFromCommandLine(String prompt) {
		return ReadFromCommandLine(prompt, 2);
	}
	public static byte[] ReadFromCommandLine(String prompt, int prompts) {
		try {
			String foo = readLine(true, "Enter %s: ", prompt);
			String foo2 = "";
			boolean retryq = false;
			if (prompts != 1) {
				foo2 = readLine(true, "Reenter %s: ", prompt);
				retryq = (foo.compareTo(foo2) != 0);

				if (retryq) {
					System.out.print("");
					String retry = readLine("Values entered do not match.  Retry? Y/n/exit : ");
					switch (retry.toUpperCase()) {
					case "":
					case "Y":
					case "YES":
						return (ReadFromCommandLine(prompt, 2));
					case "N":
					case "NO":
						return null;
					case "E":
					case "EXIT":
						System.exit(1);
					}
				}
			}
			String foostr = new String(foo);
			byte [] fooba = foostr.getBytes();
			return fooba;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
}

